﻿using System.Collections.Generic;
using System.Linq;
using Implab.Automaton;

namespace Implab.Formats {
    public class CharAlphabet: IndexedAlphabetBase<char> {

        public CharAlphabet()
            : base(char.MaxValue + 1) {
        }

        public override int GetSymbolIndex(char symbol) {
            return symbol;
        }

        public override char GetSymbolByIndex(int index) {
            return (char)index;
        }

        public override IEnumerable<char> InputSymbols {
            get { return Enumerable.Range(char.MinValue, char.MaxValue).Cast<char>(); }
        }
    }
}
