﻿using System;

namespace Implab.Components {
    /// <summary>
    /// Initializable components are created and initialized in two steps, first we have create the component,
    /// then we have to complete it's creation by calling an <see cref="Init()"/> method. All parameters needed
    /// to complete the initialization must be passed before the calling <see cref="Init()"/>
    /// </summary>
    public interface IInitializable {
        /// <summary>
        /// Completes initialization.
        /// </summary>
        /// <remarks>
        /// Normally virtual methods shouldn't be called from the constructor, due to the incomplete object state, but
        /// they can be called from this method. This method is also usefull when we constructing a complex grpah
        /// of components where cyclic references may take place.
        /// </remarks>
        void Init();
    }
}

