﻿using System;

namespace Implab.Diagnostics {
    public class LogEventArgs : EventArgs {
        public string ChannelName {
            get;
            private set;
        }
        public int ThreadId {
            get;
            private set;
        }
        public LogicalOperation Operation {
            get;
            private set;
        }
        public int OperationTimeOffset {
            get;
            private set;
        }
        public LogEventArgs(string channelName, int threadId, LogicalOperation operation, int timeOffset) {
            ChannelName = channelName;
            ThreadId = threadId;
            Operation = operation;
            OperationTimeOffset = timeOffset;
        }
    }
}

