﻿
using System.Xml;

namespace Implab.Formats.JSON {
    /// <summary>
    /// Набор необязательных параметров для <see cref="JSONXmlReader"/>, позволяющий управлять процессом
    /// интерпретации <c>JSON</c> документа.
    /// </summary>
    public class JSONXmlReaderOptions {
        /// <summary>
        /// Пространство имен в котором будут располагаться читаемые элементы документа
        /// </summary>
        public string NamespaceURI {
            get;
            set;
        }

        /// <summary>
        /// Интерпретировать массивы как множественные элементы (убирает один уровень вложенности), иначе массив
        /// представляется в виде узла, дочерними элементами которого являются элементы массива, имена дочерних элементов
        /// определяются свойством <see cref="ArrayItemName"/>. По умолчанию <c>false</c>.
        /// </summary>
        public bool FlattenArrays {
            get;
            set;
        }

        /// <summary>
        /// Префикс, для узлов документа
        /// </summary>
        public string NodesPrefix {
            get;
            set;
        }

        /// <summary>
        /// Имя корневого элемента в xml документе
        /// </summary>
        public string RootName {
            get;
            set;
        }

        /// <summary>
        /// Имя элемента для массивов, если не включена опция <see cref="FlattenArrays"/>.
        /// По умолчанию <c>item</c>.
        /// </summary>
        public string ArrayItemName {
            get;
            set;
        }

        /// <summary>
        /// Таблица атомизированных строк для построения документа.
        /// </summary>
        public XmlNameTable NameTable {
            get;
            set;
        }

    }
}
