﻿using System;
using System.IO;

namespace Implab.Formats {
    public class ReaderScanner: TextScanner {
        const int CHUNK_SIZE = 1024*4;
        const int BUFFER_MAX = CHUNK_SIZE*1024;

        readonly TextReader m_reader;

        public ReaderScanner(TextReader reader, int limit, int chunk) : base(limit, chunk) {
            Safe.ArgumentNotNull(reader, "reader");
            m_reader = reader;
        }

        public ReaderScanner(TextReader reader) : this(reader, BUFFER_MAX, CHUNK_SIZE) {
        }

        protected override int Read(char[] buffer, int offset, int size) {
            return m_reader.Read(buffer, offset, size);
        }

        protected override void Dispose(bool disposing) {
            if (disposing)
                Safe.Dispose(m_reader);
            base.Dispose(disposing);
        }
    }
}

