﻿using System;
using System.Runtime.CompilerServices;

namespace Implab {
    public struct PromiseAwaiter<T> : INotifyCompletion {
        readonly IPromise<T> m_promise;

        public PromiseAwaiter(IPromise<T> promise) {
            m_promise = promise;
        }

        public void OnCompleted (Action continuation) {
            if (m_promise != null)
                m_promise.On(continuation, PromiseEventType.All);
        }

        public T GetResult() {
            return m_promise.Join();
        }

        public bool IsCompleted {
            get {
                return m_promise.IsResolved;
            }
        }
    }
}

