﻿using System;
using System.Diagnostics;
using System.Linq;
using Implab.Diagnostics;
using Implab.ServiceHost.Unity;
using Implab.Xml;
using Unity;
using Unity.Injection;
using Unity.Registration;

namespace Implab.Playground {

    public class Foo {

        public class Bar {

        }

        public string Name { get; set; }

        public int IntValue { get; set; }

        public string StringValue { get; set; }

    }

    public interface IContainer<T> {
        T Instance { get; set; }
    }

    public class Container<T> : IContainer<T> {
        public Container() {

        }

        public Container(T instance) {
            Instance = instance;
        }

        public T Instance { get; set; }

        public void SetInstance(T value) {
            Instance = value;
        }
    }

    public class Program {

        static void Main(string[] args) {
            var container = new UnityContainer();

            var ctx = new ConfigurationContext(container);

            var conf = SerializationHelpers.DeserializeFromFile<ContainerElement>("data/sample.xml");

            ctx.Visit(conf);

            DisplayContainerRegistrations(container);

            var instace1 = container.Resolve<IContainer<string>>();
            var instace2 = container.Resolve<IContainer<Foo>>();

        }

        static void DisplayContainerRegistrations(IUnityContainer theContainer) {
            string regName, regType, mapTo, lifetime;
            Console.WriteLine("Container has {0} Registrations:",
                    theContainer.Registrations.Count());
            foreach (ContainerRegistration item in theContainer.Registrations) {
                regType = item.RegisteredType.FullName;
                mapTo = item.MappedToType.FullName;
                regName = item.Name ?? "[default]";
                lifetime = item.LifetimeManager.LifetimeType.Name;
                if (mapTo != regType) {
                    mapTo = " -> " + mapTo;
                } else {
                    mapTo = string.Empty;
                }
                lifetime = lifetime.Substring(0, lifetime.Length - "LifetimeManager".Length);
                Console.WriteLine("+ {0}{1}  '{2}'  {3}", regType, mapTo, regName, lifetime);
            }
        }


    }
}
