using Implab.Xml;
using System.Collections.Generic;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    [XmlRoot("container", Namespace = Schema.ContainerConfigurationNamespace)]
    public class ContainerElement : IXmlSerializable {

        public List<IConfigurationElement> Items {get; set; } = new List<IConfigurationElement>();

        public XmlSchema GetSchema() {
            return null;
        }

        public void ReadXml(XmlReader reader) {
            while(reader.Read() && reader.NodeType != XmlNodeType.EndElement) {
                var registration = ConfigurationSchema.Default.Deserialize<IConfigurationElement>(reader);
                Items.Add(registration);
            }
        }

        public void WriteXml(XmlWriter writer) {
            foreach(var item in Items) {
                var serializer = new XmlSerializer(item.GetType());
                serializer.Serialize(writer, item);
            }
        }
    }
}