﻿using Implab.Parallels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Implab {
    public class SafePool<T> where T : new() {
        readonly MTQueue<T> m_queue = new MTQueue<T>();
        readonly int m_size;
        int m_count = 0;

        public SafePool() : this(10) {

        }

        public SafePool(int size) {
            Safe.ArgumentInRange(size,1,size,"size");

            m_size = size;
        }

        public T Allocate() {
            T instance;
            if (m_queue.TryDequeue(out instance)) {
                Interlocked.Decrement(ref m_count);
                return instance;
            }
            return new T();
        }

        public void Release(T instance) {
            if (m_count < m_size) {
                Interlocked.Increment(ref m_count);
                m_queue.Enqueue(instance);
            }
        }
    }
}
