using System;
using System.Threading;
using System.Threading.Tasks;

namespace Implab.Components
{
    public class RunnableComponent : IRunnable {

        readonly object m_lock = new object();

        CancellationTokenSource m_cts;

        public Task<ExecutionState> Completion {
            get;
            private set;
        }

        public ExecutionState State => throw new NotImplementedException();

        public Exception LastError => throw new NotImplementedException();

        public event EventHandler<StateChangeEventArgs> StateChanged;

        public void Dispose() {
            lock(m_lock) {
                Dispose(true);
                GC.SuppressFinalize(this);
            }
        }

        protected virtual void Dispose(bool disposing) {
            if (disposing) {
                Safe.Dispose(m_cts);
            }
        }

        public void Start(CancellationToken ct) {
            lock(m_lock) {
                switch (State)
                {
                    
                    default:
                        throw new InvalidOperationException();
                }
            }
        }

        public void Stop(CancellationToken ct) {
            throw new NotImplementedException();
        }

        protected virtual Task StartImpl(CancellationToken ct) {

            return Task.CompletedTask;
        }
    }
}