﻿using System;
using System.Threading;
using System.Threading.Tasks;

namespace Implab.Components {
    /// <summary>
    /// Interface for the component which performs a long running task.
    /// </summary>
    public interface IRunnable : IDisposable {
        /// <summary>
        /// Starts this instance
        /// </summary>
        void Start(CancellationToken ct);

        /// <summary>
        /// Stops this instance and releases all resources, after the instance is stopped it is moved to Disposed state and can't be reused.
        /// </summary>
        void Stop(CancellationToken ct);

        Task<ExecutionState> Completion { get; }

        ExecutionState State { get; }

        event EventHandler<StateChangeEventArgs> StateChanged;

        Exception LastError { get; }
    }
}

