﻿using Implab;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace Implab.Automaton {
    /// <summary>
    /// Indexed alphabet is the finite set of symbols where each symbol has a zero-based unique index.
    /// </summary>
    /// <remarks>
    /// Indexed alphabets are usefull in bulting efficient translations from source alphabet
    /// to the input alphabet of the automaton. It's assumed that the index to the symbol match
    /// is well known and documented.
    /// </remarks>
    public abstract class IndexedAlphabetBase<T> : MapAlphabet<T> {

        protected IndexedAlphabetBase() :base(true, null) {
        }

        public abstract int GetSymbolIndex(T symbol);

        /// <summary>
        /// Gets the translation map from the index of the symbol to it's class this is usefull for the optimized input symbols transtaion.
        /// </summary>
        /// <remarks>
        /// The map is continous and start from the symbol with zero code. The last symbol
        /// in the map is the last classified symbol in the alphabet, i.e. the map can be
        /// shorter then the whole alphabet.
        /// </remarks>
        /// <returns>The translation map.</returns>
        public int[] GetTranslationMap() {
            var map = new Dictionary<int, int>();

            int max = 0;
            foreach (var p in Mappings) {
                var index = GetSymbolIndex(p.Key);
                max = Math.Max(max, index);
                map[index] = p.Value;
            }

            var result = new int[max + 1];

            for (int i = 0; i < result.Length; i++)
                map.TryGetValue(i, out result[i]);

            return result;
        }
    }
}
