﻿using System;
using Implab;
using System.Threading.Tasks;

namespace MonoPlay {
    class MainClass {


        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var t1 = Environment.TickCount;

            DoWork().GetAwaiter().GetResult();

            var t2 = Environment.TickCount;
            Console.WriteLine("done: {0} ms, {1:.00} Mb, {2} GC", t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0) );

        }

        static IPromise<int> DoItem(int x) {
            //return Promise<int>.FromResult(x + 1);
            var p = new Promise<int>();
            p.Resolve(x+1);
            return p;
        }

        static async Task<int> DoWork() {
            var c = 0;
            for (int i = 0; i < 10000000; i++)
                c = await DoItem(c);
            return c;
        }

    }
}
