﻿using System;

namespace Implab {
    public class SuccessPromise : IPromise {
        #region IPromise implementation

        public IPromise On(Action success, Action<Exception> error, Action<Exception> cancel) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise On(Action success, Action<Exception> error) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise On(Action success) {
            if (success != null) {
                try {
                    success();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise On(Action handler, PromiseEventType events) {
            if (handler != null && events.HasFlag(PromiseEventType.Success)) {
                try {
                    handler();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> Cast<T>() {
            throw new InvalidCastException();
        }

        public void Join() {
        }

        public void Join(int timeout) {
        }

        public Type PromiseType {
            get {
                return typeof(void);
            }
        }

        public bool IsResolved {
            get {
                return true;
            }
        }

        public bool IsCancelled {
            get {
                return false;
            }
        }

        public Exception Error {
            get {
                return null;
            }
        }

        #endregion

        #region ICancellable implementation

        public void Cancel() {
        }

        public void Cancel(Exception reason) {
        }

        #endregion

    }
}

