﻿using System;

namespace Implab {
    public class ObjectPoolWrapper<T> : IDisposable {
        readonly T m_value;
        readonly ObjectPool<T> m_pool;

        internal ObjectPoolWrapper(T value, ObjectPool<T> pool) {
            m_value = value;
            m_pool = pool;
        }

        public T Value {
            get { return m_value; }
        }

        #region IDisposable implementation
        public void Dispose() {
            m_pool.Release(m_value);
        }
        #endregion
    }
}

