﻿using System.Threading;

namespace Implab {
    public class SyncContextPromise<T> : Promise<T> {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }

        public SyncContextPromise(SynchronizationContext context, IPromise parent, bool cancellable)
            : base(parent, cancellable) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }
        protected override void InvokeHandler(HandlerDescriptor handler) {
            m_context.Post(x => base.InvokeHandler(handler),null);
        }
    }
}

