using System;
using System.Xml.Serialization;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity {

    [XmlRoot("register", Namespace = Schema.ContainerConfigurationNamespace)]
    public class RegisterElement : AbstractRegistration  {
        
        /// <summary>
        /// An optional type specification for the service registration, 
        /// must be assignable from the type specified by <see cref="ImplementedType"/>
        /// </summary>
        [XmlAttribute("provides")]
        public string ProvidesType { get; set; }

        /// <summary>
        /// The type which is registered as a service in the container.
        /// </summary>
        [XmlAttribute("type")]
        public string ImplementedType { get; set; }

        [XmlElement("signleton", typeof(SimgletonLifetimeElement))]
        [XmlElement("context", typeof(ContextLifetimeElement))]
        [XmlElement("container", typeof(ContainerLifetimeElement))]
        [XmlElement("hierarchy", typeof(HierarchicalLifetimeElement))]
        public LifetimeElement Lifetime {get; set;}

        [XmlElement("constructor", typeof(ConstructorInjectionElement))]
        [XmlElement("property", typeof(PropertyInjectionElement))]
        [XmlElement("method", typeof(MethodInjectionElement))]
        public AbstractInjectionElement[] Injectors { get; set; }
    }
    
}