using System;
using System.Diagnostics;

namespace Implab {
    class PromiseHandler {
        public static Action<T, Deferred> Create<T>(Action<T> handler) {
            Debug.Assert(handler != null);

            return (v, next) => {
                try {
                    handler(v);
                    next.Resolve();
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T, Deferred> Create<T>(Func<T, IPromise> handler) {
            Debug.Assert(handler != null);

            return (v, next) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T, Deferred<T2>> Create<T, T2>(Func<T, T2> handler) {
            Debug.Assert(handler != null);

            return (v, next) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T, Deferred<T2>> Create<T, T2>(Func<T, IPromise<T2>> handler) {
            Debug.Assert(handler != null);
            return (v, next) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<Deferred> Create(Action handler) {
            Debug.Assert(handler != null);

            return (next) => {
                try {
                    handler();
                    next.Resolve();
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<Deferred> Create(Func<IPromise> handler) {
            Debug.Assert(handler != null);

            return (next) => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<Deferred<T2>> Create<T2>(Func<T2> handler) {
            Debug.Assert(handler != null);

            return (next) => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<Deferred<T2>> Create<T2>(Func<IPromise<T2>> handler) {
            Debug.Assert(handler != null);
            return (next) => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }
    }
}