﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class TextFileListener: TextListenerBase {
        readonly TextWriter m_textWriter;

        public TextFileListener(string fileName, bool local) : base(local) {
            m_textWriter = File.CreateText(fileName);

            m_textWriter.WriteLine("LOG {0}", DateTime.Now);
            Register(this);
        }

        protected override void WriteEntry(TraceContext context, EventText text) {
            var msg = new StringBuilder();
            for (int i = 0; i < text.indent; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]: {1}", context.ThreadId, text.content);

            lock (m_textWriter) {
                if (!IsDisposed) {
                    // тут гарантировано еще не освобожден m_textWriter
                    m_textWriter.WriteLine(msg.ToString());
                    m_textWriter.Flush();
                }
            }
        }

        
        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if (disposing) {
                // IsDisposed = true
                lock (m_textWriter) {
                    Safe.Dispose(m_textWriter);
                }
            }
        }

        
    }
}
