﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Implab.Diagnostics.Interactive {
    public partial class TraceForm : Form {
        readonly Dictionary<int, Color> m_threadColors = new Dictionary<int,Color>();
        readonly Random m_rand = new Random();

        public TraceForm() {
            InitializeComponent();

        }

        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            if (!e.Cancel && e.CloseReason == CloseReason.UserClosing) {
                e.Cancel = true;
                Hide();
            }
        }

        public void AddTraceEvent(int indent, int thread, string message) {
            traceViewItemBindingSource.Add(new TraceViewItem {
                Indent = indent,
                Thread = thread,
                Message = message,
                Timestamp = Environment.TickCount
            });

        }

        public void AddTraceEvent(TraceViewItem item) {
            traceViewItemBindingSource.Add(item);
        }

        Color GetThreadColor(int thread) {
            Color result;
            if (!m_threadColors.TryGetValue(thread, out result)) {
                result = Color.FromArgb(m_rand.Next(4)*64, m_rand.Next(4)*64, m_rand.Next(4)*64);
                m_threadColors[thread] = result;
            }
            return result;
        }

        private void eventsDataGrid_CellFormatting(object sender, DataGridViewCellFormattingEventArgs e) {
            var data = (TraceViewItem)traceViewItemBindingSource[e.RowIndex];
            e.CellStyle.Padding = new Padding(data.Indent * 10,0,0,0);
            e.CellStyle.ForeColor = GetThreadColor(data.Thread);
        }
    }
}
