﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise {

        /// <summary>
        /// Тип результата, получаемого через данное обещание.
        /// </summary>
        Type ResultType { get; }

        /// <summary>
        /// Обещание является выполненым, либо успешно, либо с ошибкой, либо отменено.
        /// </summary>
        bool IsFulfilled { get; }

        bool IsRejected { get; }

        bool IsResolved { get; }

        /// <summary>
        /// Исключение возникшее в результате выполнения обещания, либо причина отмены.
        /// </summary>
        Exception RejectReason { get; }

        /// <summary>
        /// Adds specified listeners to the current promise.
        /// </summary>
        /// <param name="success">The handler called on the successful promise completion.</param>
        /// <param name="error">The handler is called if an error while completing the promise occurred.</param>
        /// <returns>The current promise.</returns>
        void On(Action success, Action<Exception> error);

        /// <summary>
        /// Преобразует результат обещания к заданному типу и возвращает новое обещание.
        /// </summary>
        IPromise<T> Cast<T>();

        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        void Join();
        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        /// <param name="timeout">Время ожидания, по его истечению возникнет исключение.</param>
        /// <exception cref="TimeoutException">Превышено время ожидания.</exception>
        void Join(int timeout);

    }
}
