﻿using System;
using Implab.Parallels;

namespace Implab {
    public class Promise : AbstractPromise {
        public static readonly IPromise Success;

        static Promise() {
            Success = new SuccessPromise();
        }

        internal void ResolvePromise() {
            SetResult();
        }

        internal void RejectPromise(Exception error) {
            SetError(error);
        }

        public static IPromise Reject(Exception exception) {
            return new FailedPromise(exception);
        }
    }
}

