﻿using System;
using System.Collections.Generic;

namespace Implab.Components {
    /// <summary>
    /// Global application components and services.
    /// </summary>
    public static class App {
        readonly static ComponentContainer<object> _root = new ComponentContainer<object>();

        /// <summary>
        /// The container for application level components.
        /// </summary>
        /// <remarks>Pools of disposable objects can be placed here and they will be automatically
        /// disposed when application domain is unloaded.</remarks>
        public static ICollection<object> RootContainer {
            get { return _root; }
        }

        static App() {
            AppDomain.CurrentDomain.DomainUnload += (sender, e) => _root.Dispose();
        }
    }
}

