﻿using System;
using System.Threading;

namespace Implab {
    public abstract class AbstractTask<T> : AbstractPromise<T> {
        int m_cancelationLock;

        /// <summary>
        /// Получает эксклюзивное право отмены задания, используется для отмены задания до начала его выполнения.
        /// </summary>
        /// <returns><c>true</c>, if cancelation was locked, <c>false</c> otherwise.</returns>
        protected bool LockCancelation() {
            return 0 == Interlocked.CompareExchange(ref m_cancelationLock, 1, 0);
        }



        protected void SetErrorInternal(Exception error) {
            // unwrap 
            while (error is PromiseTransientException && error.InnerException != null)
                error = error.InnerException;

            if (error is OperationCanceledException)
                SetCancelled(error);
            else
                SetError(error);
        }

        protected void SetCancelledInternal(Exception reason) {
            SetCancelled(
                reason == null ? new OperationCanceledException() : reason is OperationCanceledException ? reason : new OperationCanceledException(null, reason)
            );
        }
    }
}

