﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;
using System.Collections.Generic;
using System.Collections.Concurrent;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var q1 = new MTQueue<int>();
            var q2 = new ConcurrentQueue<int>();

            const int count = 10000000;

            var t1 = Environment.TickCount;

            for (var i = 0; i < count; i++)
                q1.Enqueue(i);

            var t2 = Environment.TickCount;
            Console.WriteLine("MTQueue: {0} ms", t2 - t1);

            t1 = Environment.TickCount;

            for (var i = 0; i < count; i++)
                q2.Enqueue(i);

            t2 = Environment.TickCount;
            Console.WriteLine("LinkedList: {0} ms", t2 - t1);

            q2 = new ConcurrentQueue<int>();

            t1 = Environment.TickCount;

            for (var i = 0; i < count; i++)
                lock (q2)
                    q2.Enqueue(i);

            t2 = Environment.TickCount;
            Console.WriteLine("LinkedList+Lock: {0} ms", t2 - t1);

        }
    }
}
