﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Formats.Json {
    public class JsonTextScanner : JsonScanner {
        const int _bufferSize = 16*4096;
        readonly TextReader m_reader;

        JsonTextScanner(TextReader reader, char[] buffer) : base(buffer, 0, 0) {
            m_reader = reader;
        }

        protected override int Read(char[] buffer, int offset, int size) {
            return m_reader.Read(buffer, offset, size);
        }

        public static JsonTextScanner Create(string file, Encoding encoding) {
            return new JsonTextScanner(new StreamReader(file, encoding), new char[_bufferSize]);
        }

        public static JsonTextScanner Create(string file) {
            return new JsonTextScanner(new StreamReader(file), new char[_bufferSize]);
        }

        public static JsonTextScanner Create(Stream stream, Encoding encoding) {
            return new JsonTextScanner(new StreamReader(stream, encoding), new char[_bufferSize]);
        }

        public static JsonTextScanner Create(Stream stream) {
            return new JsonTextScanner(new StreamReader(stream), new char[_bufferSize]);
        }

        public static JsonTextScanner Create(TextReader reader) {
            Safe.ArgumentNotNull(reader, nameof(reader));
            return new JsonTextScanner(reader, new char[_bufferSize]);
        }

        protected override void Dispose(bool disposing) {
            if (disposing)
                Safe.Dispose(m_reader);

            base.Dispose(disposing);
        }
    }
}
