﻿using System;

namespace Implab {
    public class ActionTaskBase : AbstractTask {
        readonly Action<Exception> m_cancel;
        readonly Action<Exception> m_error;

        protected ActionTaskBase( Action<Exception> error, Action<Exception> cancel, bool autoCancellable) {
            m_error = error;
            m_cancel = cancel;
            if (autoCancellable)
                CancellationRequested(CancelOperation);
        }

        public void Reject(Exception error) {
            Safe.ArgumentNotNull(error, "error");
            if (LockCancelation())
                HandleErrorInternal(error);
        }

        public override void CancelOperation(Exception reason) {
            if (LockCancelation())
                HandleCancelInternal(reason);
        }

        protected void HandleErrorInternal(Exception error) {
            if (m_error != null) {
                try {
                    m_error(error);
                    SetResult();
                } catch(Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetErrorInternal(error);
            }
        }

        protected void HandleCancelInternal(Exception error) {
            if (m_cancel != null) {
                try {
                    m_cancel(error);
                    SetResult();
                } catch(Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetCancelledInternal(error);
            }
        }
    }
}

