﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise: ICancellable {
        /// <summary>
        /// Check whereather the promise has no more than one dependent promise.
        /// </summary>
        bool IsExclusive {
            get;
        }

        /// <summary>
        /// Тип результата, получаемого через данное обещание.
        /// </summary>
        Type PromiseType { get; }

        bool IsResolved { get; }

        bool IsCancelled { get; }

        IPromise Then(Action success,ErrorHandler error);
        IPromise Then(Action success);
        IPromise Error(ErrorHandler error);
        IPromise Anyway(Action handler);
        IPromise Finally(Action handler);
        IPromise Cancelled(Action handler);

        IPromise<T> Cast<T>();

        void Join();
        void Join(int timeout);

    }
}
