﻿using System;

namespace Implab {
    public interface IPromise<T> : IPromise {

        new T Join();

        new T Join(int timeout);

        void Last(Action<T> success, Action<Exception> error, Action cancel);
        
        void Last(Action<T> success, Action<Exception> error);

        void Last(Action<T> success);

        IPromise<T> Then(Action<T> success, Func<Exception,T> error, Action cancel);

        IPromise<T> Then(Action<T> success, Func<Exception,T> error);

        IPromise<T> Then(Action<T> success);

        IPromise<T2> Then<T2>(Func<T, T2> mapper, Func<Exception,T2> error, Action cancel);

        IPromise<T2> Then<T2>(Func<T, T2> mapper, Func<Exception,T2> error);

        IPromise<T2> Then<T2>(Func<T, T2> mapper);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained, Func<Exception,IPromise<T2>> error, Action cancel);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained, Func<Exception,IPromise<T2>> error);

        IPromise<T2> Chain<T2>(Func<T, IPromise<T2>> chained);

        IPromise<T> Error(Func<Exception,T> error);

        new IPromise<T> Cancelled(Action handler);

        new IPromise<T> Anyway(Action handler);
    }
}
