using System;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class SerializedElement : AbstractRegistration, ISerializedValue {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAttribute("serializedType")]
        public string SerializedType { get; set; }


        [XmlAnyElement]
        public XmlElement[] Content { get; set; }

        string ISerializedValue.TypeName {
            get {
                return string.IsNullOrEmpty(SerializedType) ? RegistrationType : SerializedType;
            }
        }

        public string TypeName => throw new NotImplementedException();

        public override void Visit(ContainerBuilder context) {
            context.Visit(this);
        }

        public XmlReader GetReader() {
            if (!string.IsNullOrEmpty(Location))
                return XmlReader.Create(Location);
            if (Content != null && Content.Length > 0)
                return Content[0].CreateNavigator().ReadSubtree();

            throw new Exception("No content found, expected XML document");
        }

        public void Visit(InjectionValueBuilder builder) {
            throw new NotImplementedException();
        }
    }
}