using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ValueElement : AbstractRegistration, ITextValue {
        
        [XmlAttribute("value")]
        public string Value { get; set; }

        [XmlText]
        public string Text { get; set; }

        string ITextValue.Value {
            get {
                return string.IsNullOrEmpty(Value) ? Text : Value;
            }
        }

        public string TypeName {
            get {
                return RegistrationType;
            }
        }

        public override void Visit(ContainerBuilder context) {
            context.Visit(this);
        }
    }
}