﻿using System;

namespace Implab {
    public class ActionTask<T> : ActionTaskBase, IDeferred<T> {
        readonly Action<T> m_task;
        public ActionTask(Action<T> task, Action<Exception> error, Action<Exception> cancel, bool autoCancellable) : base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve(T value) {
            if (m_task != null && LockCancelation()) {
                try {
                    m_task(value);
                    SetResult();
                } catch(OperationCanceledException reason) {
                    HandleCancelInternal(reason);
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}

