﻿using Implab;

namespace Implab.Automaton.RegularExpressions {
    public abstract class BinaryToken<TTag> : Token<TTag> {
        readonly Token<TTag> m_left;
        readonly Token<TTag> m_right;

        public Token<TTag> Left {
            get { return m_left; }
        }

        public Token<TTag> Right {
            get { return m_right; }
        }

        protected BinaryToken(Token<TTag> left, Token<TTag> right) {
            Safe.ArgumentNotNull(m_left = left, "left");
            Safe.ArgumentNotNull(m_right = right, "right");
        }
    }
}
