﻿using System;
using System.Reflection;

namespace Implab {
    public class FailedPromise : IPromise {
        readonly Exception m_error;
        public FailedPromise(Exception error) {
            Safe.ArgumentNotNull(error, "error");
            m_error = error;
        }

        #region IPromise implementation

        public IPromise On(Action success, Action<Exception> error, Action<Exception> cancel) {
            if (error != null) {
                try {
                    error(m_error);  
                // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise On(Action success, Action<Exception> error) {
            if (error != null) {
                try {
                    error(m_error);  
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise On(Action success) {
            return this;
        }

        public IPromise On(Action handler, PromiseEventType events) {
            if ((events & PromiseEventType.Error) != 0) {
                try {
                    handler();
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> Cast<T>() {
            return (IPromise<T>)this;
        }

        public void Join() {
            throw new TargetInvocationException(RejectReason);
        }

        public void Join(int timeout) {
            throw new TargetInvocationException(RejectReason);
        }

        public virtual Type ResultType {
            get {
                return typeof(void);
            }
        }

        public bool IsFulfilled {
            get {
                return true;
            }
        }

        public bool IsCancelled {
            get {
                return false;
            }
        }

        public Exception RejectReason {
            get {
                return m_error;
            }
        }

        #endregion

        #region ICancellable implementation

        public void Cancel() {
        }

        public void Cancel(Exception reason) {
        }

        #endregion
    }
}

