﻿namespace Implab.Diagnostics {
    public static class Extensions {
        public static IPromise<T> EndLogicalOperation<T>(this IPromise<T> promise) {
            Safe.ArgumentNotNull(promise, "promise");
            var op = TraceContext.Instance.DetachLogicalOperation();

            return promise.On(
                x => {
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceInformation("promise = {0}", x);
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                },
                err =>{
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceError("promise died {0}", err);
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                },
                reason => {
                    TraceContext.Instance.EnterLogicalOperation(op,true);
                    TraceLog.TraceInformation("promise cancelled {0}", reason == null ? "<no-reason>" : reason.Message);
                    TraceLog.EndLogicalOperation();
                    TraceContext.Instance.Leave();
                }
            );
        }

        public static IPromise EndLogicalOperation(this IPromise promise) {
            Safe.ArgumentNotNull(promise, "promise");
            var op = TraceContext.Instance.DetachLogicalOperation();

            return promise.On(() => {
                TraceContext.Instance.EnterLogicalOperation(op,true);
                TraceLog.EndLogicalOperation();
                TraceContext.Instance.Leave();
            }, PromiseEventType.All);
        }
    }
}

