using System;
using System.Diagnostics;

namespace Implab.Diagnostics {
    public class LogicalOperation {
        public Stopwatch OperationStopwatch { get; private set; }

        public string Name { get; private set; }

        internal LogicalOperation(string name) {
            Name = string.IsNullOrEmpty(name) ? "<unnamed>" : name;
            OperationStopwatch = Stopwatch.StartNew();
        }

        public override string ToString() => Name;
    }
}