﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab
{
    public interface IPromise
    {
        /// <summary>
        /// Check whereather the promise has no more than one dependent promise.
        /// </summary>
        bool IsExclusive
        {
            get;
        }

        /// <summary>
        /// The current state of the promise.
        /// </summary>
        PromiseState State
        {
            get;
        }

        /// <summary>
        /// Tries to cancel the promise or the complete chain.
        /// </summary>
        /// <param name="dependencies">Try to cancel the whole promise chain, the parent promise will be cancelled only if it has only one promise</param>
        /// <returns></returns>
        bool Cancel(bool dependencies);
    }
}
