﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Automaton {
    /// <summary>
    /// Алфавит. Множество символов, которые разбиты на классы, при этом классы имеют непрерывную нумерацию,
    /// что позволяет использовать их в качестве индексов массивов.
    /// </summary>
    /// <remarks>
    /// <para>Алфавит является сюрьективным отображением множества символов в множество индексов, это позволяет сократить размер таблицы переходов автомата
    /// для входных символов, которые для него не различимы.</para>
    /// </remarks>
    /// <typeparam name="TSymbol">Тип символов.</typeparam>
    public interface IAlphabet<TSymbol> {
        /// <summary>
        /// Количество классов символов в алфавите.
        /// </summary>
        int Count { get; }

        /// <summary>
        /// Преобразует входной символ в индекс символа из алфавита.
        /// </summary>
        /// <param name="symobl">Исходный символ</param>
        /// <returns>Индекс в алфавите</returns>
        int Translate(TSymbol symobl);

        bool Contains(TSymbol symbol);

        IEnumerable<TSymbol> GetSymbols(int cls);
    }
}
