﻿using System;
using System.Text;

namespace Implab.Diagnostics {
    public class ConsoleTraceListener: ListenerBase {

        static readonly object _consoleLock = new object();

        public override void Write(LogEventArgs args, object entry) {
            var msg = new StringBuilder();

            for (int i = 0; i < args.Operation.Level; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]: {1}", args.ThreadId, entry);

            lock (_consoleLock) {
                Console.ForegroundColor = (ConsoleColor)(args.ThreadId % 15 + 1);
                Console.WriteLine(msg);
            }
        }
    }
}
