﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise<T> : IPromise {

        new T Join();

        new T Join(int timeout);

        void Last(ResultHandler<T> success, ErrorHandler error, Action cancel);
        
        void Last(ResultHandler<T> success, ErrorHandler error);

        void Last(ResultHandler<T> success);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error, Action cancel);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error);

        IPromise<T> Then(ResultHandler<T> success);

        IPromise<T2> Then<T2>(ResultMapper<T, T2> mapper, ErrorHandler<T2> error, Action cancel);

        IPromise<T2> Then<T2>(ResultMapper<T, T2> mapper, ErrorHandler<T2> error);

        IPromise<T2> Then<T2>(ResultMapper<T, T2> mapper);

        IPromise<T2> Chain<T2>(ResultMapper<T, IPromise<T2>> chained, ErrorHandler<IPromise<T2>> error, Action cancel);

        IPromise<T2> Chain<T2>(ResultMapper<T, IPromise<T2>> chained, ErrorHandler<IPromise<T2>> error);

        IPromise<T2> Chain<T2>(ResultMapper<T, IPromise<T2>> chained);

        IPromise<T> Error(ErrorHandler<T> error);

        new IPromise<T> Cancelled(Action handler);

        new IPromise<T> Anyway(Action handler);
    }
}
