﻿using Implab.Parallels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Implab.Diagnostics.Interactive
{
    public class InteractiveTracer: Disposable
    {
        TraceForm m_form;
        SynchronizationContext m_syncGuiThread;
        readonly IPromiseBase m_completed;
        readonly Promise<object> m_started = new Promise<object>();

        public InteractiveTracer() {
            m_completed = AsyncPool.InvokeNewThread(() => {
                GuiThread();
                return 0;
            });

            m_started.Join();
        }

        void GuiThread() {
            m_form = new TraceForm(); // will create SynchronizationContext
            m_syncGuiThread = SynchronizationContext.Current;
            m_started.Resolve();
            Application.Run();
        }

        public void ShowForm() {
            m_syncGuiThread.Post(x => m_form.Show(), null);
        }

        public void HideForm() {
            m_syncGuiThread.Post(x => m_form.Hide(), null);
        }

        void Terminate() {
            m_syncGuiThread.Post(x => Application.ExitThread(), null);
        }

        protected override void Dispose(bool disposing) {
            if (disposing) {
                Terminate();
                m_completed.Join();
            }
            base.Dispose(disposing);
        }
    }
}
