﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Implab.Diagnostics.Interactive {
    public partial class TraceViewControl : UserControl {
        int m_maxEvents = 1000;

        string m_status = "ready";
        
        readonly LinkedList<TraceViewItem> m_events = new LinkedList<TraceViewItem>();
        public TraceViewControl() {
            InitializeComponent();

            var ticks = Environment.TickCount;

            for (int i = 0; i < 1333; i++) {
                AddViewItem(new TraceViewItem {
                    indent = i % 4,
                    message = String.Format("Auto generated {0}", i),
                    thread = 2,
                    timestamp = ticks + i*10
                });
            }
        }

        public void AddViewItem(TraceViewItem item) {
            m_events.AddLast(item);
            if (m_events.Count > m_maxEvents)
                m_events.RemoveFirst();
        }

        protected override void OnPaint(PaintEventArgs e) {
            base.OnPaint(e);

            if (m_status != null)
                e.Graphics.DrawString(m_status, DefaultFont, Brushes.Black, 0, 0);
            
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);

            m_status = String.Format("({0},{1})", e.X, e.Y);
            Invalidate();
        }
        
    }
}
