﻿using System;

namespace Implab {
    public class ActionChainTask : ActionChainTaskBase, IDeferred {
        readonly Func<IPromise> m_task;

        /// <summary>
        /// Initializes a new instance of the <see cref="Implab.ActionChainTask"/> class.
        /// </summary>
        /// <param name="task">The operation which will be performed when the <see cref="Resolve()"/> is called.</param>
        /// <param name="error">The error handler which will invoke when the <see cref="Reject(Exception)"/> is called or when the task fails with an error.</param>
        /// <param name="cancel">The cancellation handler.</param>
        /// <param name="autoCancellable">If set to <c>true</c> will automatically accept
        ///  all cancel requests before the task is started with <see cref="Resolve()"/>,
        /// after that all requests are directed to the task.</param>
        public ActionChainTask(Func<IPromise> task, Func<Exception, IPromise> error, Func<Exception, IPromise> cancel, bool autoCancellable) : base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    var p = m_task();
                    p.On(SetResult, HandleErrorInternal, HandleCancelInternal);
                    CancellationRequested(p.Cancel);
                } catch (OperationCanceledException reason){
                    HandleCancelInternal(reason);
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }

    }
}

