using System;
using System.Reflection;
using System.Runtime.ExceptionServices;

namespace Implab {
    static class ExceptionHelpers {
        public static Exception Rethrow(this Exception that) {
            ExceptionDispatchInfo.Capture(that).Throw();
            return new TargetInvocationException(that);
        }

        public static Exception Wrap(this Exception that) {
            if (that == null)
                return new Exception();
            else if (that is OperationCanceledException)
                return new OperationCanceledException("The operation has been cancelled", that);
            else
                return new TargetInvocationException(that);
        }
    }
}