﻿using System;

namespace Implab.Formats {
    public class StringScanner: TextScanner {
        const int CHUNK_SIZE = 1024;

        readonly string m_text;
        int m_pos;

        public StringScanner(string text) : base(text.Length, text.Length < CHUNK_SIZE ? text.Length : CHUNK_SIZE) {
            m_text = text;
            Feed();
        }

        protected override int Read(char[] buffer, int offset, int size) {
            var actual = size + m_pos > m_text.Length ? m_text.Length - m_pos : size;

            m_text.CopyTo(m_pos,buffer,offset, actual);

            m_pos += actual;

            return actual;
        }
    }
}

