﻿using System;

namespace Implab.Diagnostics {
    public class TraceEvent {
        public string Message {
            get;
            private set;
        }

        public TraceEventType EventType {
            get;
            private set;
        }

        public TraceEvent(TraceEventType type, string message) {
            EventType = type;
            Message = message;
        }

        public override string ToString() {
            /*return EventType == TraceEventType.Information ? Message : String.Format("{0}: {1}", EventType, Message);*/
            return Message;
        }

        public static TraceEvent Create(TraceEventType type, string format, params object[] args) {
            return new TraceEvent(type, format == null ? String.Empty : String.Format(format, args));
        }
    }
}
