﻿using System;
using System.IO;
using System.Text;

namespace Implab.Diagnostics {
    public class TextFileListener: ListenerBase {
        readonly TextWriter m_textWriter;

        public TextFileListener(string fileName) {
            m_textWriter = File.CreateText(fileName);

            m_textWriter.WriteLine("LOG {0}", DateTime.Now);
        }

        #region implemented abstract members of ListenerBase

        public override void Write(LogEventArgs args, object entry) {
            var msg = new StringBuilder();
            for (int i = 0; i < args.Operation.Level; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]:{1}: {2}", args.ThreadId, args.ChannelName, entry);

            lock (m_textWriter) {
                if (!IsDisposed) {
                    // тут гарантировано еще не освобожден m_textWriter
                    m_textWriter.WriteLine(msg);
                    m_textWriter.Flush();
                }
            }
        }

        #endregion

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if (disposing) {
                // IsDisposed = true
                lock (m_textWriter) {
                    Safe.Dispose(m_textWriter);
                }
            }
        }

        
    }
}
