﻿using Implab;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace Implab.Automaton.RegularExpressions {
    /// <summary>
    /// </summary>
    public class RegularExpressionVisitor<TTag> : RegularExpressionVisitor {
        readonly Dictionary<int, TTag> m_tags = new Dictionary<int, TTag>();

        readonly ITaggedDFABuilder<TTag> m_builder;

        public RegularExpressionVisitor(ITaggedDFABuilder<TTag> builder) : base(builder) {
            m_builder = builder;
        }

        public override void Visit(EndToken token) {
            base.Visit(token);
            var tagged = token as EndToken<TTag>;
            if (tagged != null)
                m_tags.Add(Index, tagged.Tag);
        }

        protected override void MarkFinalState(HashSet<int> state) {
            base.MarkFinalState(state);
            m_builder.SetStateTag(Translate(state), GetStateTags(state));
        }

        TTag[] GetStateTags(IEnumerable<int> state) {
            Debug.Assert(state != null);
            return state.Where(m_tags.ContainsKey).Select(pos => m_tags[pos]).ToArray();
        }

    }
}
