﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromiseBase: ICancellable {
        /// <summary>
        /// Check whereather the promise has no more than one dependent promise.
        /// </summary>
        bool IsExclusive {
            get;
        }

        /// <summary>
        /// Тип результата, получаемого через данное обещание.
        /// </summary>
        Type PromiseType { get; }

        bool IsResolved { get; }

        bool IsCancelled { get; }

        IPromiseBase Then(Action success,ErrorHandler error);
        IPromiseBase Then(Action success);

        IPromise<T> Cast<T>();

    }
}
