﻿using System;
using Implab.Diagnostics;
using Implab.Parallels;
using Implab;

namespace MonoPlay {
    class MainClass {
        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");

            var listener = new ConsoleTraceListener(true);
            listener.Subscribe<TraceEvent>();

            MTComponentContainer.AppContainer.Add(listener);

            TraceLog.StartLogicalOperation("program");

            TraceLog.StartLogicalOperation("async");
            AsyncPool.Invoke(() => {
                TraceLog.TraceInformation("Hello async");
                TraceLog.StartLogicalOperation("foo");
                return 0;
            })
                .EndLogicalOperation()
                .Join();

            TraceLog.EndLogicalOperation();

        }
    }
}
